<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nik', 'full_name', 'user_id', 'department_id', 'position_id', 'date_joined', 'date_end', 'gender', 'date_birth');

    public function department()
    {
        return $this->hasOne('App\Model\Department');
    }

}